<#ibiztemplate>
TARGET=PSDATAENTITY
</#ibiztemplate>
<#assign needconv = false>
<#if de.getStorageMode()==0>
        <#comment>判断无存储实体中的外键是否有物理化bson主表字段，有则需要输出类型转换器</#comment>
        <#if item.getMinorPSDERs?? && item.getMinorPSDERs()??>
            <#list item.getMinorPSDERs() as MinorPSDER>
                <#if MinorPSDER?? && MinorPSDER.getDERType()=='DER1N'>
                    <#if MinorPSDER.getMajorPSDataEntity?? && MinorPSDER.getMajorPSDataEntity()?? && MinorPSDER.getCodeName?? && MinorPSDER.getCodeName()??>
                        <#assign MajorEntity = MinorPSDER.getMajorPSDataEntity()>
                        <#if MajorEntity.getCodeName?? && MinorPSDER.getCodeName()?? && MajorEntity.getStorageMode()==1>
                            <#if MinorPSDER.getPSOne2ManyDataDEField()?? && MinorPSDER.getPSOne2ManyDataDEField().isPhisicalDEField()==true>
                            <#assign needconv=true>
                            </#if>
                        </#if>
                    </#if>
                </#if>
            </#list>
        </#if>
</#if>
<#if needconv==true>
package ${pub.getPKGCodeName()}.core.${item.getPSSystemModule().getCodeName()?lower_case}.domain.handlers;

import ${pub.getPKGCodeName()}.core.${item.getPSSystemModule().getCodeName()?lower_case}.domain.${item.getCodeName()};
import com.baomidou.mybatisplus.extension.handlers.AbstractJsonTypeHandler;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.extern.slf4j.Slf4j;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Slf4j
@MappedTypes({List.class})
@MappedJdbcTypes(JdbcType.VARCHAR)
public class ${item.getCodeName()}TypeHandler extends AbstractJsonTypeHandler<List>
{
    private static ObjectMapper objectMapper = new ObjectMapper();
    private JavaType type;

    public ${item.getCodeName()}TypeHandler(Class<List> type) {
        this.type = objectMapper.getTypeFactory().constructParametricType(ArrayList.class, ${item.getCodeName()}.class);
    }

    @Override
    protected List parse(String json) {
        try {
            return objectMapper.readValue(json, type);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String toJson(List obj) {
        try {
            return objectMapper.writeValueAsString(obj);
        } catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setObjectMapper(ObjectMapper objectMapper) {
        ${item.getCodeName()}TypeHandler.objectMapper = objectMapper;
    }
}
</#if>



